/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DateAttribute;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.StringAttribute;
import org.vikamine.kernel.data.Value;

public class AttributeBuilder {
    protected Attribute attribute;
    private static final int NOMINAL_VALUES_REQUIRED = 1;

    public static Attribute createEmptyIDAttribute() {
        AttributeBuilder b = new AttributeBuilder();
        b.buildStringAttribute("ID");
        return b.getAttribute();
    }

    public void buildNumericAttribute(String attributeName) {
        this.attribute = new NumericAttribute(attributeName);
    }

    public void buildNominalAttribute(String attributeName, List<String> rawValuesList) {
        this.attribute = new NominalAttribute(attributeName, rawValuesList);
    }

    public void buildStringAttribute(String attributeName) {
        this.attribute = new StringAttribute(attributeName);
    }

    public void buildDateAttribute(String attributeName, String dateFormat) {
        this.attribute = new DateAttribute(attributeName, dateFormat);
    }

    public Attribute getAttribute() {
        NominalAttribute attr;
        int fail = 0;
        if (this.attribute.isNominal() && this.attribute instanceof NominalAttribute && ((attr = (NominalAttribute)this.attribute).getNominalValues() == null || attr.getNominalValues().size() != attr.getRawValuesCount())) {
            ++fail;
        }
        if (fail > 0) {
            throw new IllegalStateException("Attribute not fully initialized!" + fail);
        }
        return this.attribute;
    }

    public void buildNominalValues() {
        LinkedList<Value> nominalValues = new LinkedList<Value>();
        NominalAttribute dna = (NominalAttribute)this.attribute;
        int i = 0;
        while (i < dna.getRawValuesCount()) {
            SingleValue val = new SingleValue(dna, i, dna.getRawValue(i));
            nominalValues.add(val);
            ++i;
        }
        ((NominalAttribute)this.attribute).setNominalValues(nominalValues);
    }
}

