/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.introspect;

import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.subgroup.SupportingFactor;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResult;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResultSet;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class PrototypicalPatternCase {
    private final List<SGSelector> principleFactors;
    private final List<SupportingFactor> supportingFactors;
    private List<SGNominalSelector> prototypicalPatternCases;
    private final CBRResultSet resultSet;

    public PrototypicalPatternCase(List<SGSelector> principleFactors, List<SupportingFactor> supportingFactors, CBRResultSet resultSet) {
        this.principleFactors = principleFactors;
        this.supportingFactors = supportingFactors;
        this.resultSet = resultSet;
    }

    public List<SGNominalSelector> getPrototypicalPatternCases() {
        return this.prototypicalPatternCases;
    }

    public void setPrototypicalPatternCases(List<SGNominalSelector> explicationCases) {
        this.prototypicalPatternCases = explicationCases;
    }

    public List<SGSelector> getPrincipalFactors() {
        return this.principleFactors;
    }

    public List<SupportingFactor> getSupportingFactors() {
        return this.supportingFactors;
    }

    public List<DataRecord> getCasesToSelector(SGNominalSelector selector, Ontology ontology) {
        LinkedList<DataRecord> records = new LinkedList<DataRecord>();
        if (selector != null) {
            for (CBRResult result : this.resultSet.getResults()) {
                if (!selector.isContainedInInstance(result.getRetrievedCase())) continue;
                long theCaseID = result.getRetrievedCase().getID();
                DataRecord theCase = this.searchForDataRecordWithID(theCaseID, ontology);
                records.add(theCase);
            }
        }
        return records;
    }

    private DataRecord searchForDataRecordWithID(long id, Ontology ontology) {
        for (DataRecord record : ontology.getDataset()) {
            if (record.getID() != id) continue;
            return record;
        }
        return null;
    }

    public List<SGSelector> getUnionOfPrincipleAndSupportingFactors() {
        LinkedList<SGSelector> union = new LinkedList<SGSelector>();
        union.addAll(this.principleFactors);
        for (SupportingFactor supportingFactor : this.supportingFactors) {
            union.add(supportingFactor.getSelector());
        }
        return union;
    }
}

