% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ie_misconduct.R
\name{ie_misconduct}
\alias{ie_misconduct}
\title{Search for itemized misconduct incident reports}
\usage{
ie_misconduct(contractor = NULL, contracting_party = NULL,
  date_year = NULL, enforcement_agency = NULL, instance = NULL,
  penalty_amount = NULL, page = NULL, per_page = NULL, as = "table",
  key = NULL, ...)
}
\arguments{
\item{contractor}{(character)    The name of the contractor to search for.}

\item{contracting_party}{(character)  The FIPS code for the contracting agency.}

\item{date_year}{(numeric) The year in which a date significant to the incident occurred.}

\item{enforcement_agency}{(character)    The name of the agency responsible for the enforcement action.}

\item{instance}{(character)  Full-text search on the description of the misconduct instance.}

\item{penalty_amount}{(numeric) The amount of the penalty, in US dollars.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}
}
\value{
A data.frame (default), list, or httr response object.
}
\description{
Search for itemized misconduct incident reports
}
\examples{
\dontrun{
ie_misconduct(contractor='SAIC', date_year=2012)
ie_misconduct(instance='Castle Harbour Tax Shelter')
ie_misconduct(date_year=2012, per_page=2)

ie_misconduct(penalty_amount=5000000)
ie_misconduct(contractor='GlaxoSmithKline', per_page=3)

# most parameters are vectorized, pass in more than one value
ie_misconduct(date_year = c(2010, 2011), per_page=2)
}
}

