% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_nominations.R
\name{cg_nominations}
\alias{cg_nominations}
\title{Search for data on nominations}
\usage{
cg_nominations(nomination_id = NULL, congress = NULL, number = NULL,
  received_on = NULL, last_action_at = NULL, organization = NULL,
  committee_ids = NULL, nominees = NULL, nominees.position = NULL,
  nominees.state = NULL, query = NULL, fields = NULL, page = 1,
  per_page = 20, order = NULL, key = NULL, as = "table", ...)
}
\arguments{
\item{nomination_id}{The unique identifier for this nomination, taken from the Library of
Congress. Of the form 'PN[number]-[congress]'.}

\item{congress}{The Congress in which this nomination was presented.}

\item{number}{The number of this nomination, taken from the Library of Congress. Can
occasionally contain hyphens, e.g. 'PN64-01'.}

\item{received_on}{The date this nomination was received in the Senate.}

\item{last_action_at}{The date this nomination last received action. If there are no official
actions, then this field will fall back to the value of received_on.}

\item{organization}{The organization the nominee would be appointed to, if confirmed.}

\item{committee_ids}{An array of IDs of committees that the nomination has been referred to
for consideration.}

\item{nominees}{An array of objects with fields (described below) about each nominee.
Nominations for civil posts tend to have only one nominee. Nominations for military posts tend
to have batches of multiple nominees. In either case, the nominees field will always be an array.}

\item{nominees.position}{The position the nominee is being nominated for.}

\item{nominees.state}{The which state in the United States this nominee hails from. This field
is only available for some nominees, and never for batches of multiple nominees.}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{key}{your SunlightLabs API key; loads from environment variable from .Renviron or
from an option from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}
}
\description{
Search for data on nominations
}
\examples{
\dontrun{
cg_nominations(order='received_on')
cg_nominations(committee_ids='SSAS')
cg_nominations(organization='Privacy and Civil Liberties Oversight Board')
cg_nominations(query='Petraeus')

# most parameters are vectorized, pass in more than one value
cg_nominations(party = c('PN1873-111', 'PN604-112'))
}
}

