% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_get_form_metadata.R
\name{scto_get_form_metadata}
\alias{scto_get_form_metadata}
\title{Fetch form metadata from a SurveyCTO server}
\usage{
scto_get_form_metadata(
  auth,
  form_ids = NULL,
  deployed_only = FALSE,
  get_defs = TRUE
)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{form_ids}{Character vector indicating the form ids. \code{NULL} indicates
all forms.}

\item{deployed_only}{Logical indicating whether to fetch metadata for all
versions of each form, or only for the deployed version.}

\item{get_defs}{Logical indicating whether to fetch form definitions.}
}
\value{
A \code{data.table} with one row per form (and per version, if
\code{deployed_only} is \code{FALSE}). Definitions are returned as nested
\code{data.table}s, which can be unnested using
\code{\link[=scto_unnest_form_definitions]{scto_unnest_form_definitions()}}.
}
\description{
This function fetches metadata, including form definitions, for deployed and
previous versions of one or more forms.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
form_metadata = scto_get_form_metadata(auth, 'my_form')
form_defs = scto_unnest_form_definitions(form_metadata)
}

}
