% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enableAddon.R
\name{enableAddon}
\alias{enableAddon}
\alias{enableAddon,character-method}
\alias{enableAddon,SsimLibrary-method}
\title{Enable addon package(s)}
\usage{
enableAddon(ssimLibrary, name)

\S4method{enableAddon}{character}(ssimLibrary, name)

\S4method{enableAddon}{SsimLibrary}(ssimLibrary, name)
}
\arguments{
\item{ssimLibrary}{\code{\link{SsimLibrary}} object}

\item{name}{character string or vector of addon name(s)}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful activation 
of the addon) or \code{FALSE} upon failure.
}
\description{
Enable \code{\link{addon}} package(s) of a \code{\link{SsimLibrary}}.
}
\examples{
\donttest{
# Install "stsim" SyncroSim package
addPackage("stsim")

# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession, 
                         package = "stsim")

# Enable add on package
enableAddon(myLibrary, c("stsimsf"))
addon(myLibrary)

# Disable add on package
disableAddon(myLibrary, c("stsimsf"))
addon(myLibrary)
}

}
\seealso{
\code{\link{addon}}
}
