% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clo.R
\name{cloPlotTraj}
\alias{cloPlotTraj}
\title{Plots the bivariate state variable's clo model-predicted temporal trajectories for each latent profile of clo parameters.}
\usage{
cloPlotTraj(
  prepData,
  paramEst,
  n_profiles,
  dist0name = NULL,
  dist1name = NULL,
  plot_obs_name = NULL,
  minMax = NULL,
  time_length = NULL,
  printPlots = T
)
}
\arguments{
\item{prepData}{A dataframe that was produced with the "dataPrep" function.}

\item{paramEst}{A dataframe created by indivClo containing the clo parameter estimates for each dyad.}

\item{n_profiles}{The number of latent profiles.}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable (e.g., "Women"). Default is dist0.}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable (e.g., "Men"). Default is dist1}

\item{plot_obs_name}{An optional name for the observed state variable to appear on plots (e.g., "Emotional Experience").}

\item{minMax}{An optional vector with desired minimum and maximum quantiles to be used for setting the y-axis range on the plots, e.g., minMax <- c(.1, .9) would set the y-axis limits to the 10th and 90th percentiles of the observed state variables. If not provided, the default is to use the minimum and maximum observed values of the state variables.}

\item{time_length}{An optional value specifying how many time points to plot across. Default is the 75th percentile for the observed time variable.}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
The function returns the plots as a list.
}
\description{
Plots the bivariate state variable's clo model-predicted temporal trajectories for each latent profile of clo parameters.
}
\examples{
# See vignettes for examples.

}
