% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{decode_tokens}
\alias{decode_tokens}
\title{Decodes tokens back to text}
\usage{
decode_tokens(tokens, model)
}
\arguments{
\item{tokens}{a vector of tokens to decode, or a list of tokens}

\item{model}{a model to use for tokenization, either a model name, e.g., \verb{gpt-4o}
or a tokenizer, e.g., \code{o200k_base}.
See also \href{https://github.com/zurawiki/tiktoken-rs/blob/main/tiktoken-rs/src/tokenizer.rs}{available tokenizers}.}
}
\value{
a character string of the decoded tokens or a vector or strings
}
\description{
Decodes tokens back to text
}
\examples{
tokens <- get_tokens("Hello World", "gpt-4o")
tokens
decode_tokens(tokens, "gpt-4o")

tokens <- get_tokens(c("Hello World", "Alice Bob Charlie"), "gpt-4o")
tokens
decode_tokens(tokens, "gpt-4o")
}
\seealso{
\code{\link[=model_to_tokenizer]{model_to_tokenizer()}}, \code{\link[=get_tokens]{get_tokens()}}
}
