% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{omega2const}
\alias{omega2const}
\alias{set_omega_const}
\alias{set_w_const}
\alias{w2const}
\title{Set process relative starting-point to constants}
\usage{
omega2const(model, names, constants = NA)

set_omega_const(model, names, constants = NA)

set_w_const(model, names, constants = NA)

w2const(model, names, constants = NA)
}
\arguments{
\item{model}{An object of the class \code{rtmpt_model}.}

\item{names}{Character vector with process names.}

\item{constants}{Numerical vector of length one or \code{length(names)}. You have the following options for the elements of the numeric vector:
\itemize{
 \item \code{0 < constants < 0}: set the named relaitve starting-point parameter(s) to constant value(s) larger than zero and smaller than 1
 \item \code{NA}: estimate the named relaitve starting-point parameter(s)
}}
}
\value{
An object of the class \code{drtmpt_model}.
}
\description{
Setting process relative starting-point (omega/w) to constants or change it back to be estimated.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process relative starting-point for guessing (g) will be set to 0.5.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_drtmpt_model(mdl_file = mdl_2HTM)

## setting relative starting-point for g to a constant (1.0):
new_model <- omega2const(model = model, names = c("g"), constants = c(0.5))
new_model


## setting relative starting-point of g to a constant (0.5):
new_model <- set_omega_const(model = model, names = c("g"), constants = c(0.5))
new_model

## setting relative starting-point of g to a constant (0.5):
new_model <- set_w_const(model = model, names = c("g"), constants = c(0.5))
new_model

## setting relative starting-point of g to a constant (0.5):
new_model <- w2const(model = model, names = c("g"), constants = c(0.5))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{a2const}}, \code{\link{a2a}}, \code{\link{nu2const}}, \code{\link{nu2nu}}, and \code{\link{omega2omega}}
}
\author{
Raphael Hartmann
}
