% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_tweets}
\alias{search_tweets}
\title{search_tweets}
\usage{
search_tweets(q, n = 100, type = "mixed", max_id = NULL, parse = TRUE,
  token = NULL, verbose = TRUE, ...)
}
\arguments{
\item{q}{Character, search query of no greater than
500 characters maximum.}

\item{n}{Numeric, specifying the total number of desired tweets to
return. Defaults to 100. Maximum number of tweets returned from
a single token is 18,000. See details for more information.}

\item{type}{Character, specifies what type of search results
you would prefer to receive. The current default is
\code{type = "mixed"}, which is a mix between the other two
valid values \code{type = "recent"} and \code{type = "popular"}.}

\item{max_id}{Character, specifying the [oldest] status id beyond
which results should resume returning.}

\item{parse}{Logical, indicating whether to return parsed
(data.frames) or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves users from the time
[and frustrations] associated with disentangling the Twitter
API return objects.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}

\item{verbose}{Logical, indicating whether or not to output
processing/retrieval messages.}

\item{\dots}{Futher arguments passed on to \code{make_url}.
All named arguments that do not match the above arguments
(i.e., count, type, etc.) will be built into the request.
To return only English language tweets, for example, use
\code{lang = "en"}. Or, to exclude retweets, use
\code{include_rts = FALSE}. For more options see Twitter's
API documentation.}
}
\value{
List object with tweets and users each returned as a
  data frame.
}
\description{
Returns two data frames (tweets data and users data)
  using a provided search query.
}
\details{
Twitter API document recommends limiting searches to
  10 keywords and operators. Complex queries may also produce
  API errors preventing recovery of information related to
  the query.
  It should also be noted Twitter's search API does not consist
  of an index of all Tweets. At the time of searching, the
  search API index includes between only 6-9 days of Tweets.


  Number of tweets returned will often be less than what was
  specified by the user. This can happen because (a) the search
  query did not return many results (the search pool is already
  thinned out from the population of tweets to begin with) or
  (b) because you hit your rate limit for a given token. Even if
  the query has lots of hits and the rate limit should be able to
  max out at 18,000, the returned number of tweets may be lower,
  but that's only because the functions filter out duplicates
  (e.g., 18,000 tweets were actually returned, but 30 of them were
  removed because they were repeats).
}
\examples{
\dontrun{
# search for 1000 tweets mentioning Hillary Clinton
hrc <- search_tweets(q = "hillaryclinton", n = 1000)

# data frame where each observation (row) is a different tweet
hrc

# users data also retrieved. can access it via users_data()
users_data(hrc)

# search for 1000 tweets in English
djt <- search_tweets(q = "realdonaldtrump", n = 1000, lang = "en")
djt # prints tweets data preview
users_data(djt) # prints users data preview
}
}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other tweets: \code{\link{get_favorites}},
  \code{\link{get_timeline}},
  \code{\link{lookup_statuses}},
  \code{\link{stream_tweets}}, \code{\link{tweets_data}}
}

