% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lat_lng.R
\name{lat_lng}
\alias{lat_lng}
\title{Adds single-point latitude and longitude variables to tweets data.}
\usage{
lat_lng(
  x,
  coords = c("coords_coords", "bbox_coords", "geo_coords"),
  prefs = "bbox_coords"
)
}
\arguments{
\item{x}{Parsed Twitter data as returned by various rtweet
functions. This should be a data frame with variables such as
"bbox_coords", "coords_coords", and "geo_coords" (among
other non-geolocation Twitter variables).}

\item{coords}{Names of variables containing latitude and longitude
coordinates.  Priority is given to bounding box coordinates (each
obs consists of eight entries) followed by the supplied order of
variable names. Defaults to "bbox_coords",
"coords_coords", and "geo_coords") (which are the default column
names of data returned by most status-oriented rtweet functions).}

\item{prefs}{Preference of coordinates to use as default, must be in \code{coords}.}
}
\value{
Returns updated data object with full information latitude
and longitude vars.
}
\description{
Appends parsed Twitter data with latitude and longitude variables
using all available geolocation information.
}
\details{
On occasion values may appear to be outliers given a
previously used query filter (e.g., when searching for tweets
sent from the continental US).  This is typically because those
tweets returned a large bounding box that overlapped with the
area of interest. This function converts boxes into their
geographical midpoints, which works well in the vast majority of
cases, but sometimes includes an otherwise puzzling result.
}
\examples{

if (auth_has_default()) {

## stream tweets sent from the US
rt <- stream_tweets(lookup_coords("usa"), timeout = 10)

## use lat_lng to recover full information geolocation data
rtl_loc <- lat_lng(rt)
rtl_loc
}

}
\seealso{
Other geo: 
\code{\link{lookup_coords}()}
}
\concept{geo}
