% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gsi_em_1}
\alias{gsi_em_1}
\title{EM algorithm from the simplest GSI model for pi and the individual posterior probabilities}
\usage{
gsi_em_1(SL, Pi_init, max_iterations, tolerance, return_progression)
}
\arguments{
\item{SL}{a matrix of the scaled likelihoods.  This is should have values for each individual in a column
(going down in the rows are values for different collections).}

\item{Pi_init}{Starting value for the pi (collection mixture proportion) vector.}

\item{max_iterations}{the maximum total number of reps iterations to do.}

\item{tolerance}{the EM-algorithm will be considered converged when the sum over the elements of pi of the absolute value
of the difference between the previous and the current estimate is less than tolerance.}

\item{return_progression}{If true, then the pi_trace component of the output shows the value of pi visited en route to the end.}
}
\value{
\code{gsi_em_1} returns a final Maximum-Likelihood estimate for pi and PofZ,
as well as the number of iterations needed to reach convergence ("iterations_performed"),
and traces of the pi values and change in pi in each iteration
}
\description{
Using a matrix of scaled likelihoods, this function does an EM algorithm to climb the
likelihood surface for pi, and computes the plug-in estimate of the posteriors
for all the individuals.  It returns the output in a list.
}
\examples{
# this is shown with a scaled likelihood matrix from self-assignment
# of the reference individuals
params <- tcf2param_list(alewife, 17)
logl <- geno_logL(params)
SL <- apply(exp(logl), 2, function(x) x/sum(x))
test_em <- gsi_em_1(SL,
                    rep(1/params$C, params$C),
                    max_iterations = 10^6,
                    tolerance = 10^-7,
                    return_progression = TRUE)
}
\keyword{internal}
