% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mixture_draw}
\alias{mixture_draw}
\title{Separate a chosen proportion of a reference dataset into a mixture with known population proportions}
\usage{
mixture_draw(D, rhos = NULL, omegas = NULL, N, min_remaining = 0)
}
\arguments{
\item{D}{a two-column genetic dataframe with "indiv", "repunit", and "collection" columns}

\item{rhos}{a vector of the desired reporting unit proportions in the mixture set;
if not named, will be assumed to be ordered by order of appearance in the dataset}

\item{omegas}{the desired collection proportions in the mixture set}

\item{N}{the total size of the mixture set}

\item{min_remaining}{the fraction of any collection in the reference dataset which must remain
at the end of the draw}
}
\value{
\code{mixture_draw} returns a list of two data frames,
"mixture" being the random sample taken, and "reference" being the remaining samples
}
\description{
Takes a reference dataset and a set of population proportions, either at the collection
or reporting unit level. Randomly samples individuals to satisfy these desired proportions,
and splits them into a new "mixture" dataframe.
}
\examples{
rhos <- as.vector(gtools::rdirichlet(1, table(alewife$repunit)))
cross_val <- mixture_draw(D = alewife, rhos = rhos, N = 100, min_remaining = .005)

}
\keyword{internal}
