% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure.R
\name{ruler-report}
\alias{ruler-report}
\alias{is_report}
\alias{get_report}
\title{Tidy data validation report}
\usage{
is_report(.x, .skip_class = FALSE)

get_report(.object)
}
\arguments{
\item{.x}{Object to test.}

\item{.skip_class}{Whether to skip checking inheritance from \code{ruler_report}.}

\item{.object}{Object to get \code{report} value from \code{exposure} attribute.}
}
\value{
\code{get_report()} returns \code{report} element of \code{object} if it is
exposure and of its 'exposure' attribute otherwise.
}
\description{
A tibble representing the data validation result of certain data units in
tidy way:
\itemize{
\item \strong{pack} \verb{<chr>} : Name of rule pack from column 'name' of corresponding
\link{packs_info} object.
\item \strong{rule} \verb{<chr>} : Name of the rule defined in rule pack.
\item \strong{var} \verb{<chr>} : Name of the variable which validation result is reported.
Value '.all' is reserved and interpreted as 'all columns as a whole'.
\strong{Note} that \code{var} doesn't always represent the actual column in data frame
(see \link[=group-pack]{group packs}).
\item \strong{id} \verb{<int>} : Index of the row in tested data frame which validation
result is reported. Value 0 is reserved and interpreted as 'all rows as a
whole'.
\item \strong{value} \verb{<lgl>} : Whether the described data unit obeys the rule.
}
}
\details{
There are four basic combinations of \code{var} and \code{id} values which
define five basic data units:
\itemize{
\item \code{var == '.all'} and \code{id == 0}: Data as a whole.
\item \code{var != '.all'} and \code{id == 0}: Group (\code{var} shouldn't be an actual column
name) or column (\code{var} should be an actual column name) as a whole.
\item \code{var == '.all'} and \code{id != 0}: Row as a whole.
\item \code{var != '.all'} and \code{id != 0}: Described cell.
}
}
\examples{
my_row_packs <- row_packs(
  row_mean_props = . \%>\% dplyr::transmute(row_mean = rowMeans(.)) \%>\%
    dplyr::transmute(
      row_mean_low = row_mean > 20,
      row_mean_high = row_mean < 60
    ),
  row_outlier = . \%>\% dplyr::transmute(row_sum = rowSums(.)) \%>\%
    dplyr::transmute(
      not_row_outlier = abs(row_sum - mean(row_sum)) / sd(row_sum) < 1.5
    )
)
my_data_packs <- data_packs(
  data_dims = . \%>\% dplyr::summarise(
    nrow = nrow(.) == 32,
    ncol = ncol(.) == 5
  )
)

mtcars_exposed <- mtcars \%>\%
  expose(my_data_packs, .remove_obeyers = FALSE) \%>\%
  expose(my_row_packs)

mtcars_exposed \%>\% get_report()

mtcars_exposed \%>\%
  get_report() \%>\%
  is_report()
}
