% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_2M_loglik}
\alias{DAGM_2M_loglik}
\title{DAGM-2M log-likelihood (with skewness)}
\usage{
DAGM_2M_loglik(
  param,
  daily_ret,
  mv_m_1,
  mv_m_2,
  K_1,
  K_2,
  distribution,
  lag_fun = "Beta"
)
}
\arguments{
\item{param}{Vector of starting values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m_1}{first MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{mv_m_2}{second MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K_1}{Number of (lagged) realizations of the first MIDAS variable to consider.}

\item{K_2}{Number of (lagged) realizations of the second MIDAS variable to consider.}

\item{distribution}{The conditional density to use for the innovations. At the moment, valid choices are "norm" and "std", for the Normal
and Student-t distributions.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the DAGM with two MIDAS variables, with an asymmetric term linked to past negative returns,
according to two errors' conditional distributions: Normal and Student-t.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
\donttest{
# conditional density of the innovations: normal
start_val<-c(0.01,0.80,0.05,0.2,0.1,1.1,0.4,1.1,0.5,1.1,0,1.1)
r_t<-sp500['2005/2010']
mv_m_1<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
mv_m_2<-mv_into_mat(r_t,diff(indpro),K=24,"monthly")
sum(DAGM_2M_loglik(start_val,r_t,mv_m_1,mv_m_2,K_1=12,K_2=24,distribution="norm"))
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
