% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/extract.runjags.R
\name{extract.runjags}
\alias{dic.runjags}
\alias{extract}
\alias{extract.jags}
\alias{extract.runjags}
\title{Extract peripheral information from runjags objects}
\usage{
\method{extract}{runjags}(x, what, force.resample = FALSE, ...)
}
\arguments{
\item{x}{an object of class runjags.}

\item{what}{the information contained in the runjags object to be extracted.  See the details section for the available options.}

\item{force.resample}{option to re-draw new deviance/DIC/PED etc samples from the model (using \code{\link[rjags]{dic.samples}}) rather than using any statistics that may already be available from the saved runjags object}

\item{...}{additional options to be passed to \code{\link[rjags]{dic.samples}}}
}
\description{
Objects of class 'runjags' are produced by \code{\link{run.jags}}, \code{\link{results.jags}} and \code{\link{autorun.jags}}, and contain the MCMC chains as well as all information required to extend the simulation.  This function allows specific information to be extracted from these functions.  For other utility methods for the runjags class, see \code{\link{runjags-class}}.
}
\details{
The supported options for the 'what' argument are as follows:
\itemize{
\item{crosscorr}{the cross-correlation matrix}
\item{summary}{the same as the summary method for runjags object}
\item{model}{the model}
\item{data}{the data}
\item{end.state}{the model state at the last iteration (or initial values for non-updated models) which will be used to start an extended simulation}
\item{samplers}{a matrix giving the sampler used for stochastic nodes (not available for all models)}
\item{stochastic}{a logical vector of length equal to the number of variables indicating which variables are stochastic, with NA values for variables that are stochastic in one chain but not others - the return value of this can be passed to the 'vars' argument for combine.mcmc etc functions}
\item{dic}{the DIC, as returned by \code{\link[rjags]{dic.samples}}}
\item{dic}{the PED, as returned by \code{\link[rjags]{dic.samples}} with type="popt"}
\item{sum.deviance}{the sum of the mean estimated deviance for each stochastic variable}
\item{sum.pd}{the sum of the mean estimated pD for each stochastic variable}
\item{sum.popt}{the sum of the mean estimated pOpt for each stochastic variable}
\item{mean.deviance}{the mean estimated pD for each stochastic variable}
\item{mean.pd}{the mean estimated pD for each stochastic variable}
\item{mean.popt}{the mean estimated pOpt for each stochastic variable}
\item{full.deviance}{the sum of the model deviance at each iteration (for each chain)}
\item{full.pd}{the sum of the estimated pD at each iteration}
}
Note that for the deviance/DIC related parameters, these will be extracted from the available information if possible, or otherwise re-sampled.
}
\seealso{
\code{\link{runjags-class}} for additional methods for runjags objects, \code{\link{add.summary}} for details on plot, print and summary methods for runjags class objects, \code{\link{runjags.options}} for general options available, and \code{\link{run.jags}} and \code{\link{autorun.jags}} for the functions that create objects of this class.
}
\keyword{models}

