% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_func.R
\name{RunningSd}
\alias{RunningSd}
\title{Fast Running Standard Deviation Computation}
\usage{
RunningSd(x, W, circular = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{W}{A numeric scalar; length of \code{x} window over which sample variance is computed.}

\item{circular}{Logical; whether  running sample standard deviation is computed assuming
circular nature of  \code{x} time-series (see Details).}
}
\value{
A numeric vector.
}
\description{
Computes running sample standard deviation of a time-series \code{x} in a fixed length window.
}
\details{
The length of output vector equals the length of \code{x} vector.
Parameter \code{circular} determines whether \code{x} time-series is assumed to have a  circular nature.
Assume \eqn{l_x} is the length of time-series \code{x}, \code{W} is a fixed length of \code{x} time-series window.

If \code{circular} equals \code{TRUE} then
  \itemize{
    \item first element of the output time-series corresponds to sample standard deviation of \code{x[1:W]},
    \item last element of the output time-series corresponds to sample standard deviation of \code{c(x[l_x], x[1:(W - 1)])}.
  }

If \code{circular} equals \code{FALSE} then
  \itemize{
    \item first element of the output time-series corresponds to sample standard deviation of \code{x[1:W]},
    \item the \eqn{l_x - W + 1}-th element of the output time-series corresponds to sample standard deviation of \code{x[(l_x - W + 1):l_x]},
    \item last \code{W-1} elements of the output time-series are filled with \code{NA}.
  }

See \code{runstats.demo(func.name = "RunningSd")} for a detailed presentation.
}
\examples{
x <- rnorm(10)
RunningSd(x, 3, circular = FALSE)
RunningSd(x, 3, circular = FALSE)

}
