% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPortfolio.R
\name{getPortfolio}
\alias{getPortfolio}
\title{Retrieve portfolio data from different brokers/exchanges}
\usage{
getPortfolio(
  src = "",
  board = "MOEX",
  api.key = "",
  clientId = "",
  verbose = TRUE
)
}
\arguments{
\item{src}{character indicating the name of the broker/exchange (options are 'tinkoff', 'finam', or 'alor')}

\item{board}{character indicating the name of the board (only required for Alor, default is 'MOEX')}

\item{api.key}{character representing the authorization key required for accessing broker/exchange API}

\item{clientId}{character representing the ID of the client whose portfolio data is being retrieved}

\item{verbose}{logical value indicating whether to print verbose output (default is TRUE)}
}
\value{
A list of portfolio data containing the positions and other relevant information
}
\description{
This function retrieves portfolio data from different brokers/exchanges such as Tinkoff, Finam and Alor.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
# Retrieve portfolio data from Tinkoff
getPortfolio(src = 'tinkoff', api.key = 'my_api_key', clientId = 'my_client_id')

# Retrieve portfolio data from Finam
getPortfolio(src = 'finam', api.key = 'my_api_key', clientId = 'my_client_id')

# Retrieve portfolio data from Alor
getPortfolio(src = 'alor', api.key = 'my_api_key', clientId = 'my_client_id', board = 'MOEX')
}
\author{
Vyacheslav Arbuzov
}
