% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWT3_PO.R
\name{IWT3_PO}
\alias{IWT3_PO}
\title{Inverse 3-d MRA wavelet transform (periodized, orthogonal).}
\usage{
IWT3_PO(wc, L, qmf)
}
\arguments{
\item{wc}{3-d wavelet transform (n by n by n array, n dyadic).}

\item{L}{coarse level.}

\item{qmf}{quadrature mirror filter.}
}
\value{
\code{x} 3-d signal reconstructed from wc.
}
\description{
If \code{wc} is the result of a forward 3d wavelet transform, with \code{wc <- FWT3_PO(x, L, qmf)}.
then \code{x <- IWT3_PO(wc, L, qmf)} reconstructs \code{x} exactly
\code{qmf} is a nice qmf, e.g. one made by \code{\link{MakeONFilter}}.
}
\details{
3-D counterpart of Donoho's IWT2_PO, original matlab code by
Vicki Yang and Brani Vidakovic.
}
\examples{
qmf <- MakeONFilter('Daubechies', 10)
L <- 3
x <- array(rnorm(32^3), c(32, 32, 32))
wc <- FWT3_PO(x, L, qmf)
xr <- IWT3_PO(wc, L, qmf)
}
\seealso{
\code{\link{FWT3_PO}}, \code{\link{MakeONFilter}}.
}
