% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{fbpskdemod}
\alias{fbpskdemod}
\title{BPSK Demodulator}
\usage{
fbpskdemod(r)
}
\arguments{
\item{r}{- received signal vector}
}
\value{
returns a vector of 1's and 0's corresponding to BPSK demodulation of the input vector
}
\description{
Receives a vector of real values, corresponding to a
BPSK modulated signal transmitted through a communications channel
(e.g., signal plus noise). An input value < 1 is mapped to an
output value of 0, otherwise to a value of 1.
}
\examples{
Eb=1
Nbits=10
bits <- sample(0:1,Nbits, replace=TRUE)
s <- fbpskmod(bits)
EbNodB=8
No = Eb/(10^(EbNodB/10))
n <- fNo(Nbits,No)
r <- s+n
bitsr <- fbpskdemod(r)
biterrs<-bits[bitsr!=bits]
Pberr=length(biterrs)/length(bits)
}
\seealso{
Other rwirelesscom functions: \code{\link{eyediagram}};
  \code{\link{f16pskdemod}}; \code{\link{f16pskmod}};
  \code{\link{f16qamdemod}}; \code{\link{f16qammod}};
  \code{\link{f64qamdemod}}; \code{\link{f64qammod}};
  \code{\link{f8pskdemod}}; \code{\link{f8pskmod}};
  \code{\link{fNo}}; \code{\link{fbpskmod}};
  \code{\link{fqpskdemod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}; \code{\link{stemplot}}
}

