% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/location.R
\name{set_location}
\alias{set_location}
\title{Specifies location of request}
\usage{
set_location(zip_code = NULL, territory = NULL, city = NULL,
  airport_code = NULL, PWS_id = NULL, lat_long = NULL, autoip = NULL)
}
\arguments{
\item{zip_code}{zip code}

\item{territory}{state if in US, otherwise country}

\item{city}{city name}

\item{airport_code}{IATA/ICAO airport code}

\item{PWS_id}{personal weather station ID}

\item{lat_long}{latitude and longitude}

\item{autoip}{location based on IP}
}
\value{
formatted and validated location string
}
\description{
This is a wrapper function that will validate and format location strings
for requesting data from weather underground.
}
\examples{
set_location(zip_code = "90210")
set_location(territory = "Hawaii", city = "Honolulu")
set_location(territory = "Kenya", city = "Mombasa")
set_location(airport_code = "SEA")
set_location(PWS_id = "KMNCHASK10")
set_location(autoip = "172.227.205.140")
set_location()
}

