% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/err.R
\name{rxErrTypeCombine}
\alias{rxErrTypeCombine}
\title{Combine transformations and error structures}
\usage{
rxErrTypeCombine(oldErrType, newErrType)
}
\arguments{
\item{oldErrType}{This is the old transformation, by default is
zero representing no prior transformation. This parameter is
first to allow piping. When the parameter \code{addTransform} is
missing and \code{oldErrType} is a character value, this functions
swaps \code{oldErrType} and \code{addTransform} and assigns
\code{oldErrType} to zero assuming that there is no prior
distribution.}

\item{newErrType}{This is the new distribution that is being
"added" to the current transformation.  These assumes the inputs
are in the preferred distribution name, as determined by
\code{rxPreferredDistributionName()}}
}
\value{
The new transformation as a factor
}
\description{
Combine error information to figure out what transformation is
being applied for the current endpoint
}
\examples{

rxErrTypeCombine("probitNorm")

rxErrTypeCombine("probitNorm") \%>\%
  rxErrTypeCombine("boxCox")


}
\author{
Matthew Fidler
}
\keyword{internal}
