# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Scaled Inverse Chi Squared distribution
#'
#' @param n Number of random samples
#' 
#' @param nu degrees of freedom of inverse chi square
#' 
#' @param scale  Scale of inverse chi squared distribution 
#'         (default is 1).
#' 
#' @return a vector of inverse chi squared deviates.
#' 
#' @examples
#' rinvchisq(3, 4, 1) ## Scale = 1, degrees of freedom = 4
#' rinvchisq(2, 4, 2) ## Scale = 2, degrees of freedom = 4
#' @export
rinvchisq <- function(n = 1L, nu = 1.0, scale = 1) {
    .Call(`_rxode2random_rinvchisq`, n, nu, scale)
}

#' One correlation sample from the LKJ distribution
#'
#' @param d The dimension of the correlation matrix
#' 
#' @param eta The scaling parameter of the LKJ distribution.
#'   Must be > 1.  Also related to the degrees of freedom nu.
#'   eta = (nu-1)/2.
#' 
#' @param cholesky boolean; If `TRUE` return the cholesky
#'   decomposition.
#'
#' @return A correlation sample from the LKJ distribution
#' 
#' @author Matthew Fidler (translated to RcppArmadillo) and Emma Schwager
#' @export
#' @keywords internal
rLKJ1 <- function(d, eta = 1.0, cholesky = FALSE) {
    .Call(`_rxode2random_rLKJ1`, d, eta, cholesky)
}

rLKJcv1 <- function(sd, eta = 1.0) {
    .Call(`_rxode2random_rLKJcv1`, sd, eta)
}

rLKJcvLsd1 <- function(logSd, logSdSD, eta = 1.0) {
    .Call(`_rxode2random_rLKJcvLsd1`, logSd, logSdSD, eta)
}

#' One correlation sample from the Inverse Wishart distribution
#'
#' This correlation is constructed by transformation of the Inverse Wishart
#' random covariate to a correlation.
#'
#' @inheritParams rLKJ1
#' 
#' @param nu Degrees of freedom of the Wishart distribution
#' 
#' @inheritParams cvPost
#'
#' @return One correlation sample from the inverse wishart
#' 
#' @author Matthew Fidler
#' @keywords internal
#' @export
invWR1d <- function(d, nu, omegaIsChol = FALSE) {
    .Call(`_rxode2random_invWR1d`, d, nu, omegaIsChol)
}

rcvC1 <- function(sdEst, nu = 3.0, diagXformType = 1L, rType = 1L, returnChol = FALSE) {
    .Call(`_rxode2random_rcvC1`, sdEst, nu, diagXformType, rType, returnChol)
}

cvPost_ <- function(nuS, omegaS, nS, omegaIsCholS, returnCholS, typeS, diagXformTypeS) {
    .Call(`_rxode2random_cvPost_`, nuS, omegaS, nS, omegaIsCholS, returnCholS, typeS, diagXformTypeS)
}

expandTheta_ <- function(thetaS, thetaMatS, thetaLowerS, thetaUpperS, nStudS, nCoresRVS) {
    .Call(`_rxode2random_expandTheta_`, thetaS, thetaMatS, thetaLowerS, thetaUpperS, nStudS, nCoresRVS)
}

expandPars_ <- function(objectS, paramsS, eventsS, controlS) {
    .Call(`_rxode2random_expandPars_`, objectS, paramsS, eventsS, controlS)
}

nestingInfo_ <- function(omega, data) {
    .Call(`_rxode2random_nestingInfo_`, omega, data)
}

rxRmvn_ <- function(A_, mu, sigma, ncores = 1L, isChol = FALSE) {
    .Call(`_rxode2random_rxRmvn_`, A_, mu, sigma, ncores, isChol)
}

rxMvnrnd <- function(n, L, l, u, mu, a = 0.4, tol = 2.05) {
    .Call(`_rxode2random_rxMvnrnd`, n, L, l, u, mu, a, tol)
}

rxCholperm <- function(Sig, l, u, eps = 1e-10) {
    .Call(`_rxode2random_rxCholperm`, Sig, l, u, eps)
}

rxGradpsi <- function(y, L, l, u) {
    .Call(`_rxode2random_rxGradpsi`, y, L, l, u)
}

rxNleq <- function(l, u, L) {
    .Call(`_rxode2random_rxNleq`, l, u, L)
}

rxMvrandn_ <- function(A_, mu, sigma, lower, upper, ncores = 1L, a = 0.4, tol = 2.05, nlTol = 1e-10, nlMaxiter = 100L) {
    .Call(`_rxode2random_rxMvrandn_`, A_, mu, sigma, lower, upper, ncores, a, tol, nlTol, nlMaxiter)
}

#' This seeds the engine based on the number of cores used in random number generation
#'
#' @param ncores is the number of cores to use.
#' @keywords internal
#' @return Nothing, called for side effects
#' @export
#' @examples
#' rxSeedEng()
rxSeedEng <- function(ncores = 1L) {
    .Call(`_rxode2random_rxSeedEng`, ncores)
}

rxnbinomMu_ <- function(size, mu, n, ncores) {
    .Call(`_rxode2random_rxnbinomMu_`, size, mu, n, ncores)
}

rxnbinom_ <- function(size, prob, n, ncores) {
    .Call(`_rxode2random_rxnbinom_`, size, prob, n, ncores)
}

rxbinom_ <- function(n0, prob, n, ncores) {
    .Call(`_rxode2random_rxbinom_`, n0, prob, n, ncores)
}

rxcauchy_ <- function(location, scale, n, ncores) {
    .Call(`_rxode2random_rxcauchy_`, location, scale, n, ncores)
}

rxchisq_ <- function(df, n, ncores) {
    .Call(`_rxode2random_rxchisq_`, df, n, ncores)
}

rxexp_ <- function(rate, n, ncores) {
    .Call(`_rxode2random_rxexp_`, rate, n, ncores)
}

rxf_ <- function(df1, df2, n, ncores) {
    .Call(`_rxode2random_rxf_`, df1, df2, n, ncores)
}

rxgamma_ <- function(shape, rate, n, ncores) {
    .Call(`_rxode2random_rxgamma_`, shape, rate, n, ncores)
}

rxbeta_ <- function(shape1, shape2, n, ncores) {
    .Call(`_rxode2random_rxbeta_`, shape1, shape2, n, ncores)
}

rxgeom_ <- function(prob, n, ncores) {
    .Call(`_rxode2random_rxgeom_`, prob, n, ncores)
}

rxnorm_ <- function(mean, sd, n, ncores) {
    .Call(`_rxode2random_rxnorm_`, mean, sd, n, ncores)
}

rxpois_ <- function(lambda, n, ncores) {
    .Call(`_rxode2random_rxpois_`, lambda, n, ncores)
}

rxt__ <- function(df, n, ncores) {
    .Call(`_rxode2random_rxt__`, df, n, ncores)
}

rxunif_ <- function(low, hi, n, ncores) {
    .Call(`_rxode2random_rxunif_`, low, hi, n, ncores)
}

rxweibull_ <- function(shape, scale, n, ncores) {
    .Call(`_rxode2random_rxweibull_`, shape, scale, n, ncores)
}

rxRmvn0 <- function(A_, mu, sigma, lower, upper, ncores = 1L, isChol = FALSE, a = 0.4, tol = 2.05, nlTol = 1e-10, nlMaxiter = 100L) {
    .Call(`_rxode2random_rxRmvn0`, A_, mu, sigma, lower, upper, ncores, isChol, a, tol, nlTol, nlMaxiter)
}

rxRmvnSEXP <- function(nS, muS, sigmaS, lowerS, upperS, ncoresS, isCholS, keepNamesS, aS, tolS, nlTolS, nlMaxiterS) {
    .Call(`_rxode2random_rxRmvnSEXP`, nS, muS, sigmaS, lowerS, upperS, ncoresS, isCholS, keepNamesS, aS, tolS, nlTolS, nlMaxiterS)
}

rpp_ <- function(nS, lambdaS, gammaS, probS, t0S, tmaxS, randomOrderS) {
    .Call(`_rxode2random_rpp_`, nS, lambdaS, gammaS, probS, t0S, tmaxS, randomOrderS)
}

rxordSelect <- function(u, cs) {
    .Call(`_rxode2random_rxordSelect`, u, cs)
}

#' Get the rxode2 seed
#'
#' @return rxode2 seed state or -1 when the seed isn't set
#'
#' @export
#' @seealso rxSetSeed, rxWithSeed, rxWithPreserveSeed
#' @examples
#'
#' # without setting seed
#'
#' rxGetSeed()
#' # Now set the seed
#' rxSetSeed(42)
#'
#' rxGetSeed()
#'
#' rxnorm()
#'
#' rxGetSeed()
#'
#' # don't use the rxode2 seed again
#'
#' rxSetSeed(-1)
#'
#' rxGetSeed()
#'
#' rxnorm()
#'
#' rxGetSeed()
#'
rxGetSeed <- function() {
    .Call(`_rxode2random_rxGetSeed`)
}

