% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{taxon_index_to_taxon_table}
\alias{taxon_index_to_taxon_table}
\title{Add taxon hierarchy to taxon metadata}
\usage{
taxon_index_to_taxon_table(taxa)
}
\arguments{
\item{taxa}{An existing object of class \code{safedata}}
}
\value{
A data frame adding higher taxon level information for each taxon
}
\description{
Taxon data is stored as a set of taxa with taxon ids and parent taxon
ids. For any given dataset, the set should include all parent taxa required.
This internal function takes such list of taxon data and adds columns showing
the taxonomic hierarchy for each row. It is used by \code{\link{get_taxa}} and
\code{\link{get_taxon_coverage}}.
}
\seealso{
\code{\link{get_taxa}}
}
\keyword{internal}
