% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateSettings.R
\name{validateSettings}
\alias{validateSettings}
\title{Compare a settings object with a specified data set}
\usage{
validateSettings(data, settings, chart = "eDish")
}
\arguments{
\item{data}{A data frame to check against the settings object}

\item{settings}{The settings list to compare with the data frame.}

\item{chart}{The chart type being created ("eDish" only for now)}
}
\value{
A list describing the validation state for the data/settings combination. The returned list has the following properties:
- `valid` - boolean indicating whether the settings/data combo creates a valid chart
- `status` - a string summarizing of the validation results
- `checkList` - list of lists giving details about checks performed on individual setting specifications. Each embedded item has the following properties:
 - `key` - a list specifying the position of the property being checked. For example, `list("group_cols",1,"value_col")` corresponds to `settings[["group_cols"]][[1]][["value_col"]]`
 - `text_key` - list from `key` parsed to character with a "--" separator.
 - `value` - value of the setting
 - `check` - description of the check performed.
 - `valid` - a boolean indicating whether the check was passed
 - `message` - a string describing failed checks (where `valid=FALSE`). returns an empty string when `valid==TRUE`

 @examples
 testSettings <- generateSettings(standard="adam")
 validateSettings(data=adlbc, settings=testSettings) # .$valid is TRUE
 testSettings$id_col <- "NotAColumn"
 validateSettings(data=adlbc, settings=testSettings) # .$valid is now FALSE
}
\description{
This function returns a list describing the validation status of a data set for a specified data standard
}
\details{
This function returns a list describing the validation status of a settings/data combo for a given chart type. This list can be used to populate status fields and control workflow in the Shiny app. It could also be used to manually QC a buggy chart. The tool checks that all setting properties containing "_col" match columns in the data set via \code{checkColumnSettings},  and all properties containing "_values" match fields in the data set via \code{checkFieldSettings}.
}
