% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{rforcecom.retrieve}
\alias{rforcecom.retrieve}
\title{salesforcer's backwards compatible version of rforcecom.retrieve}
\usage{
rforcecom.retrieve(session, objectName, fields, limit = NULL,
  id = NULL, offset = NULL, order = NULL, inverse = NULL,
  nullsLast = NULL)
}
\arguments{
\item{session}{\code{list}; a list containing "sessionID", "instanceURL", and "
apiVersion" as returned by \code{RForcecom::rforcecom.login()}. This argument is
ignored in all backward compatible calls because the authorization credentials 
are stored in an environment internal to the salesforcer package, so it is no longer 
necessary to pass the session in each function call.}

\item{objectName}{character; the name of the Salesforce object that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{fields}{A List of field names. (ex: c("Id", "Name", "Industry", 
"AnnualRevenue)"))}

\item{limit}{Number of the records to retrieve. (ex: 5)}

\item{id}{Record ID to retrieve. (ex: "999x000000xxxxxZZZ")}

\item{offset}{Specifies the starting row offset. (ex: "100")}

\item{order}{A list for controling the order of query results. 
(ex: "c("Industry","Name")")}

\item{inverse}{If it is TRUE, the results are ordered in descending order. 
This parameter works when order parameter has been set. (Default: FALSE)}

\item{nullsLast}{If it is TRUE, null records list in last. If not null records 
list in first. This parameter works when order parameter has been set. 
(Default: FALSE)}
}
\description{
salesforcer's backwards compatible version of rforcecom.retrieve
}
