% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\alias{check,Raster,missing-method}
\alias{check,SpatRaster,missing-method}
\alias{check,matrix,missing-method}
\alias{check,SpatRaster,SpatRaster-method}
\alias{check,Raster,Raster-method}
\alias{check,matrix,matrix-method}
\alias{check,samc,Raster-method}
\alias{check,samc,SpatRaster-method}
\alias{check,samc,matrix-method}
\alias{check,samc,numeric-method}
\title{Check landscape data}
\usage{
check(a, b)

\S4method{check}{Raster,missing}(a)

\S4method{check}{SpatRaster,missing}(a)

\S4method{check}{matrix,missing}(a)

\S4method{check}{SpatRaster,SpatRaster}(a, b)

\S4method{check}{Raster,Raster}(a, b)

\S4method{check}{matrix,matrix}(a, b)

\S4method{check}{samc,Raster}(a, b)

\S4method{check}{samc,SpatRaster}(a, b)

\S4method{check}{samc,matrix}(a, b)

\S4method{check}{samc,numeric}(a, b)
}
\arguments{
\item{a}{A \code{\link{samc-class}}, \code{\link{matrix}}, or \code{\link[raster]{RasterLayer-class}} object}

\item{b}{A \code{\link{matrix}} or \code{\link[raster]{RasterLayer-class}} object}
}
\value{
See \emph{Details} section.
}
\description{
Check that landscape inputs have valid values and matching properties.
}
\details{
This function is used to ensure that inputs (resistance, absorption, fidelity,
and occupancy) have valid values and the same properties. This includes
checking the CRS (if using raster inputs), dimensions, and locations of
cells with NA data. It can be used to directly compare two matrices or two
rasters, or it can be used to check a \code{\link{samc-class}} object
against a matrix or raster.

It can also be used to check a numeric vector against a \code{\link{samc-class}} object
created from a P matrix. In this case, the length of the vector must be equal to
the number of transient states. If the transient states are named, the vector
must contain the same names.

The function returns \code{TRUE} if the inputs have matching properties. Otherwise,
it will stop execution and print an error message with details about the
difference between the two inputs.

Note that the package assumes the different landscape inputs will be the same
type, either matrices or RasterLayers. Mixing RasterLayer data and matrix
data is not supported.
}
\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::example_split_corridor$res
abs_data <- samc::example_split_corridor$abs
init_data <- samc::example_split_corridor$init


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, init_data)

# Setup the details for a random-walk model
rw_model <- list(fun = function(x) 1/mean(x), # Function for calculating transition probabilities
                 dir = 8, # Directions of the transitions. Either 4 or 8.
                 sym = TRUE) # Is the function symmetric?


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers.
samc_obj <- samc(res_data, abs_data, model = rw_model)


# Convert the initial state data to probabilities
init_prob_data <- init_data / sum(init_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, init_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, init_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
