% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs.R
\name{srs}
\alias{srs}
\title{Simple Random Sample}
\usage{
srs(N, n, replace = FALSE, data)
}
\arguments{
\item{N}{Number of instances of the data set.}

\item{n}{Number of instances of the returning sample.}

\item{replace}{Whether the sample to be taken can have repeated instances or not.}

\item{data}{Optional matrix or data.frame containing the population data.
If specified an object of same class as data will be returned with sample instances.}
}
\value{
List of size n with numbers from 1 to N indicating the index of the
data set's instances to be taken.
}
\description{
With this function you receive a simple random sample consisting
on a list of the instances index
}
\examples{
srs(10,3)


data<-matrix(data=c(1:24), nrow=8)
N<-dim(data)[1]
sample<-srs(N, 3, data = data)
sample

}
