% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R
\name{fillet}
\alias{fillet}
\title{Chop data precisely (for programmers)}
\usage{
fillet(x, breaks, labels, left = TRUE, close_end = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{breaks}{Passed to \code{\link[=chop]{chop()}}.}

\item{labels}{Passed to \code{\link[=chop]{chop()}}.}

\item{left}{Passed to \code{\link[=chop]{chop()}}.}

\item{close_end}{Passed to \code{\link[=chop]{chop()}}.}
}
\value{
For  \verb{chop_*} functions, a factor of the same length as \code{x}.
}
\description{
Chop data precisely (for programmers)
}
\details{
\code{fillet()} calls \code{\link[=chop]{chop()}} with \code{extend = FALSE} and \code{drop = FALSE}. This
ensures that you get only the \code{breaks} and \code{labels} you ask for. When
programming, consider using \code{fillet()} instead of \code{chop()}.
}
\examples{
fillet(1:10, c(2, 5, 8))
}
\seealso{
Other chopping functions: 
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{chop}()}
}
\concept{chopping functions}
