## Do not edit this file manually.
## It has been automatically generated from *.org sources.

armaccf_xe <- function(model, lag.max = 1){
    phi <- model$ar
    theta <- model$ma
        ## 2017-10-16 accept also model$sigma2
        ##     todo: eventually remove model$sigmasq
    sigmasq <- model$sigmasq
    if(is.null(sigmasq))
        sigmasq <- model$sigma2

    p <- length(phi)
    q <- length(theta)

    lag.max <- max(lag.max, max(p,q))

    Rxe <- numeric(lag.max + 1)
    Rxe[1] <- sigmasq
    for(lag in seq(length = q)){ # TODO: this seems to assume p>q  !!!
        ind <- lag + 1
        minkp <- min(lag,p)
        Rxe[ind] <- sum(phi[1:minkp] * Rxe[lag:(lag - minkp + 1)]) + theta[lag] * sigmasq
    }

    if(p > q){  ## q, ..., min(p, lag.max) but this is always p, see above
        for(lag in (q + 1):p){
            ind <- lag + 1
            Rxe[ind] <- sum(phi[1:lag] * Rxe[lag:1])
        }
    }

    if(lag.max > p){
        for(lag in (p + 1):lag.max){
            ind <- lag + 1
            Rxe[ind] <- sum(phi[1:p] * Rxe[lag:(lag - p + 1)])
        }
    }

    term0 <- Rxe[1] + sum(theta * Rxe[ seq(from = 2, length = q)] )

    list(Rxe = Rxe, term0 = term0)
}

armaacf <- function(model, lag.max, compare = FALSE){
    xe <- armaccf_xe(model, lag.max)
    Rxe <- xe$Rxe
    term0 <- xe$term0

    phi <- model$ar
    p <- length(phi)

    acrf <- ARMAacf(model$ar, model$ma, lag.max)
    R0 <-  term0  / (1 - sum( phi * acrf[seq(from = 2, length = p)]))
    res <- acrf * R0

    if(compare){
        ## 2017-10-16 accept also model$sigma2
        ##     todo: eventually remove model$sigmasq
        sigma2 <- model$sigmasq
        if(is.null(sigma2))
            sigma2 <- model$sigma2
        res2 <- tacvfARMA(model$ar, - model$ma, lag.max, sigma2)
        ## zap small (relative to maximum before differencing) differences
        zappeddif <- zapsmall(c(max(res, res2), res - res2))[-1]

        ## this checks that the autocorrelations from ARMAacf and tacvfARMA are the same
        ## if(any(res2/res2[1] != acrf))
        ##     browser()

        cbind(native = res, tacvfARMA = res2, difference = zappeddif)
    }else
        res
}

ar2Pacf <- function(phi){
    if((p <- length(phi)) <= 1L)
        return(phi)
    
    for(k in (p - 1L):1L){
        bk <- phi[k + 1L]  # TODO: check |bk| < 1
        phi[1L:k] <- (phi[1L:k] + bk * phi[k:1L]) / (1 - bk^2)
    }
    phi
}

pacf2Ar <- function(parcor){
    p <- length(parcor)
    if(p <= 1L)
        return(parcor)
    
    ## p >= 2
    phi <- parcor # TODO: as.vector(parcor) ?
    for(k in 1L:(p - 1L))
        phi[1L:k] <- phi[1L:k] - phi[k + 1L] * phi[k:1L]
    phi
}

pacf2ArWithJacobian <- function(parcor, asis = TRUE){
    p <- length(parcor)
    J <- diag(p)
    phi <- parcor

    if(p >= 2)
        for(k in 1L:(p - 1L)){
            ## derivatives - row i contains d phi_i/d beta_j, j = 1, ...
            ## TODO: write tests
            ## 2017-12-21 was (last term change):
            ##     J[1L:k, 1L:k] <- J[1L:k, 1L:k] - phi[k + 1L] * J[1L:k, k:1L]
            J[1L:k, 1L:k] <- J[1L:k, 1L:k] - phi[k + 1L] * J[k:1L, 1L:k]

            ## this should be done before updating phi[]:
            J[1L:k, k + 1L] <- - phi[k:1L]

            ## 2017-12-21 this was before the assignments to J[]:
            phi[1L:k] <- phi[1L:k] - phi[k + 1L] * phi[k:1L]
        }

    ## TODO: think about a consistent scheme for naming:
    if(asis)
        list(phi = phi, J = J)
    else
        list(phi = - phi, J = - J)
}

hessian2vcov <- function(hessian, n, J){
   ## Y = JX; vcov(X) = (hessian * n)^(-1) 
   ## vcov(Y) = J vcov(X) J' = J (hessian * n)^(-1) J'
   J %*% solve(hessian * n) %*% t(J)
}

dbind <- function(...){
    blocks <- plain_list(...)
    if(length(blocks) == 0)
        return(matrix(0, 0, 0))
                                  # d is a 2 by n matrix
    d <- sapply(blocks, function(x){if(is.matrix(x)) dim(x) else c(length(x), 1)})

    res <- matrix(0, nrow = sum(d[1, ]), ncol = sum(d[2, ]))
    m <- n <- 0
    for(i in seq_along(blocks)){
        ## should work if d[1, i] = 0 and/or d[2,i] = 0
        res[m + seq_len(d[1, i]), n + seq_len(d[2, i])] <- blocks[[i]]
         m <- m + d[1, i]
        n <- n + d[2, i]
    }

    res
}

diag_bind <- function(...){
    blocks <- list()
    d <- rapply(list(...), function(x){ 
                               res <<- c(blocks, list(x))
                               if(is.matrix(x)) dim(x) else c(length(x), 1)
                           }
               )
    d <- matrix(d, nrow = 2)

    res <- matrix(0, nrow = sum(d[1, ]), ncol = sum(d[2, ]))
    m <- n <- 0
    for(i in seq_along(blocks)){
        ## should work if d[1, i] = 0 and/or d[2,i] = 0, as well
        res[m + seq_len(d[1, i]), n + seq_len(d[2, i])] <- blocks[[i]]
        m <- m + d[1, i]
        n <- n + d[2, i]
    }

    res
}

plain_list <- function(...){  # , .drop.null = FALSE
    object <- list(...)

    res <- list()
    rapply(object, function(x){ res <<- c(res, list(x)); NULL }, how = "list")
        # if(.drop.null)
        #     res[!sapply(res,is.null)]
        # else
    res
}
