% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sasfunclust_functions.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate data for functional clustering}
\usage{
simulate_data(
  scenario,
  n_i = 50,
  nbasis = 30,
  length_tot = 50,
  var_e = 1,
  var_b = 1
)
}
\arguments{
\item{scenario}{A  character strings indicating the scenario considered. It could be "Scenario I", "Scenario II", and "Scenario III".}

\item{n_i}{Number of curves in each cluster.}

\item{nbasis}{The dimension of the set of B-spline functions.}

\item{length_tot}{Number of evaluation points.}

\item{var_e}{Variance of the measurement error.}

\item{var_b}{Diagonal entries of the coefficient variance matrix, which is assumed to be diagonal, with equal diagonal entries, and the same among clusters.}
}
\value{
A list containing the following arguments:

\code{X}: Observation matrix, where  the rows  correspond to argument values and columns to replications.

\code{X_fd}: Functional observations without measurement error.

\code{mu_fd}: True cluster mean function.

\code{grid}: The vector of time points where the curves are sampled.

\code{clus}: True cluster membership vector.
}
\description{
Generate synthetic data as in the simulation study of Centofanti et al., 2021.
}
\examples{
library(sasfunclust)
train<-simulate_data("Scenario I",n_i=20,var_e = 1,var_b = 0.5^2)
}
