% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scAnnotate.R
\name{scAnnotate}
\alias{scAnnotate}
\title{scAnnotate}
\usage{
scAnnotate(
  train,
  test,
  distribution = c("normal", "dep"),
  correction = c("auto", "harmony", "seurat"),
  screening = c("wilcox", "t.test"),
  threshold = 0,
  lognormalized = TRUE
)
}
\arguments{
\item{train}{A data frame of cell type label in the first column and a gene expression matrix where each row is a cell and each column is a gene from training data}

\item{test}{A data matrix where each row is a cell and each column is a gene from test data}

\item{distribution}{A character string indicates the distribution assumption on positive gene expression, which should be one of "normal"(default) or "dep". "dep" refers to depth measure, which is a non-parametric distribution estimation approach.}

\item{correction}{A character string indicates the batch effect removal, which should be one of "auto"(default), "seurat", or "harmony". "auto" will automatically select the batch effect removal to follow our suggestion. That uses Seurat for dataset with at most one rare cell population (at most one cell population less than 100 cells) and Harmony for dataset with at least two rare cell populations (at least two cell populations less than 100 cells).}

\item{screening}{A character string indicates the gene screening methods, which should be one of "wilcox"(default) or "t.test".}

\item{threshold}{A numeric number indicates the threshold used for probabilities to classify cells, which should be a number from "0"(default) to "1". If there's no probability higher than the threshold associated with a cell type, the cell will be labeled as "unassigned."}

\item{lognormalized}{A logical string indicates if both input data are log-normalized or raw matrix. TRUE (default) indicates input data are log-normalized, and FALSE indicates input data are raw data.}
}
\value{
A vector contain annotate cell type labels for test data
}
\description{
Annotate cell type labels of test data using a trained mixture model from training data
}
\examples{
data(pbmc1)
data(pbmc2)
predict_label=scAnnotate(train=pbmc1,
                         test=pbmc2[,-1],
                         distribution="normal",
                         correction ="harmony",
                         screening ="wilcox",
                         threshold=0,
                         lognormalized=TRUE)
}
