% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Object_Conversion.R
\name{as.anndata}
\alias{as.anndata}
\alias{as.anndata.Seurat}
\alias{as.anndata.liger}
\title{Convert objects to anndata objects}
\usage{
as.anndata(x, ...)

\method{as.anndata}{Seurat}(
  x,
  file_path,
  file_name,
  assay = "RNA",
  main_layer = "data",
  other_layers = "counts",
  transer_dimreduc = TRUE,
  verbose = TRUE,
  ...
)

\method{as.anndata}{liger}(
  x,
  file_path,
  file_name,
  transfer_norm.data = FALSE,
  reduction_label = NULL,
  add_barcode_names = FALSE,
  barcode_prefix = TRUE,
  barcode_cell_id_delimiter = "_",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{Seurat or LIGER object}

\item{...}{Arguments passed to other methods}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{file name.}

\item{assay}{Assay containing data to use, (default is "RNA").}

\item{main_layer}{the layer of data to become default layer in anndata object (default is "data").}

\item{other_layers}{other data layers to transfer to anndata object (default is "counts").}

\item{transer_dimreduc}{logical, whether to transfer dimensionality reduction coordinates from
Seurat to anndata object (default is TRUE).}

\item{verbose}{logical, whether to print status messages during object conversion (default is TRUE).}

\item{transfer_norm.data}{logical, whether to transfer the norm.data in addition to
raw.data, default is FALSE.}

\item{reduction_label}{What to label the visualization dimensionality reduction.
LIGER does not store name of technique and therefore needs to be set manually.}

\item{add_barcode_names}{logical, whether to add dataset names to the cell barcodes when
merging object data, default is FALSE.}

\item{barcode_prefix}{logical, if \code{add_barcode_names = TRUE} should the names be added as
prefix to current cell barcodes/names or a suffix (default is TRUE; prefix).}

\item{barcode_cell_id_delimiter}{The delimiter to use when adding dataset id to barcode
prefix/suffix.  Default is "_".}
}
\value{
an anndata object generated from \code{x}, saved at path provided.
}
\description{
Convert objects (Seurat & LIGER) to anndata objects
}
\examples{
\dontrun{
as.anndata(x = seurat_object, file_path = "/folder_name", file_name = "anndata_converted.h5ad")
}

\dontrun{
as.anndata(x = liger_object, file_path = "/folder_name", file_name = "anndata_converted.h5ad")
}

}
\references{
Seurat version modified and enhanced version of \code{sceasy::seurat2anndata} (sceasy package: \url{https://github.com/cellgeni/sceasy}; License: GPL-3.  Function has additional checks and supports Seurat V3 and V5 object structure.

LIGER version inspired by \code{sceasy::seurat2anndata} modified and updated to apply to LIGER objects (sceasy package: \url{https://github.com/cellgeni/sceasy}; License: GPL-3.
}
\concept{object_conversion}
