% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/LIGER_Utilities.R, R/Utilities.R
\name{Rename_Clusters}
\alias{Rename_Clusters}
\alias{Rename_Clusters.liger}
\alias{Rename_Clusters.Seurat}
\title{Rename Clusters}
\usage{
Rename_Clusters(object, ...)

\method{Rename_Clusters}{liger}(
  object,
  new_idents,
  old_ident_name = NULL,
  new_ident_name = NULL,
  overwrite = FALSE,
  ...
)

\method{Rename_Clusters}{Seurat}(
  object,
  new_idents,
  old_ident_name = NULL,
  new_ident_name = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class Seurat or liger.}

\item{...}{Arguments passed to other methods}

\item{new_idents}{vector of new cluster names.  Must be equal to the length of current default identity
of Object.  Will accept named vector (with old idents as names) or will name the new_idents vector internally.}

\item{old_ident_name}{optional, name to use for storing current object idents in object meta data slot.}

\item{new_ident_name}{optional, name to use for storing new object idents in object meta data slot.}

\item{overwrite}{logical, whether to overwrite columns in object meta data slot. if they have same
names as \code{old_ident_name} and/or \code{new_ident_name}.}
}
\value{
An object of the same class as \code{object} with updated default identities.
}
\description{
Wrapper function to rename active cluster identity in Seurat or Liger Object with new idents.
}
\examples{
\dontrun{
# Liger version
obj <- Rename_Clusters(object = obj_name, new_idents = new_idents_vec,
old_ident_name = "LIGER_Idents_Round01", new_ident_name = "LIGER_Idents_Round02")
}

\dontrun{
obj <- Rename_Clusters(seurat_object = obj_name, new_idents = new_idents_vec,
old_ident_name = "Seurat_Idents_Round01", new_ident_name = "Round01_Res0.6_Idents")
}

}
\concept{get_set_util}
\concept{marker_annotation_util}
