% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hst.R
\name{hst.write}
\alias{hst.write}
\title{Write bursts to a log10(ms)-sqrt(Frequency) .hst file from open and closed tables.}
\usage{
hst.write(open_hist, closed_hist, file = "", header = NULL,
  fromraw = FALSE)
}
\arguments{
\item{open_hist}{The table (bin,freq,fit) for open times}

\item{closed_hist}{The table (bin,freq,fit) for closed times}

\item{file}{The filename}

\item{header}{The header info}

\item{fromraw}{Unless FALSE, assume we need to write a log10(milliseconds)-sqrt(Frequency) plot}
}
\description{
Write bursts to a log10(ms)-sqrt(Frequency) .hst file from open and closed tables.
}
\examples{

infile <- system.file("extdata", "example1_hst.hst", package = "scbursts")

open = hst.read(infile, extract="open")
closed = hst.read(infile, extract="closed")
header = hst.extract_header(infile)

### Do stuff
hst.write(open, closed, file=file.path(tempdir(), "new_histogram.hst"), header=header)
}
