% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_nbinom.R
\name{scores_nbinom}
\alias{scores_nbinom}
\alias{crps_nbinom}
\alias{logs_nbinom}
\title{Calculating scores for the negative binomial distribution}
\usage{
crps_nbinom(y, size, prob, mu)

logs_nbinom(y, size, prob, mu)
}
\arguments{
\item{y}{vector of observations.}

\item{size}{target for number of successful trials, or dispersion
    parameter (the shape parameter of the gamma mixing distribution).
    Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. \code{0 < prob <= 1}.}

\item{mu}{alternative parametrization via mean: see \sQuote{Details}.}
}
\value{
A vector of score values.
}
\description{
Calculating scores for the negative binomial distribution
}
\details{
The mean of the negative binomial distribution is given by \code{mu} = \code{size}*(1-\code{prob})/\code{prob}.
}
