% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_moments.R
\name{scores_moments}
\alias{scores_moments}
\alias{dss_moments}
\alias{ess_moments}
\title{Scoring Rules for a Vector of Moments}
\usage{
dss_moments(y, mean = 0, var = 1)

ess_moments(y, mean = 0, var = 1, skew = 0)
}
\arguments{
\item{y}{vector of realized values.}

\item{mean}{vector of mean values.}

\item{var}{vector of variance values.}

\item{skew}{vector of skewness values.}
}
\value{
Value of the score. \emph{A lower score indicates a better forecast.}
}
\description{
Calculate scores (DSS, ESS) given observations and moments of the predictive distributions.
}
\details{
The skewness of a random variable \eqn{X} is the third standardized moment 
\deqn{E[(\frac{X-\textnormal{mean}}{\sqrt{\textnormal{var}}})^3].}
}
\references{
\emph{Dawid-Sebastiani score:}

Dawid, A.P. and P. Sebastiani (1999):
'Coherent dispersion criteria for optimal experimental design'
The Annals of Statistics, 27, 65-81. \doi{10.1214/aos/1018031101}
 
\emph{Error-spread score:}
 
Christensen, H.M., I.M. Moroz, and T.N. Palmer (2015):
`Evaluation of ensemble forecast uncertainty using a new proper score:
Application to medium-range and seasonal forecasts',
Quarterly Journal of the Royal Meteorological Society, 141, 538-549. \doi{10.1002/qj.2375}
}
\author{
Alexander Jordan, Sebastian Lerch
}
