% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scvxclust.R
\name{scvxclust}
\alias{scvxclust}
\title{Sparse Convex Clustering Path}
\usage{
scvxclust(X, w, Gamma1, Gamma2, Gamma2_weight, nu = 1, tol_abs = 0.001,
  tol_rel = 1e-04, max_iter = 10000, type = 2, verbose = F,
  method = "ama", init = NULL)
}
\arguments{
\item{X}{The data matrix to be clustered. The rows are the samples, and the columns are the features.}

\item{w}{A vector of nonnegative weights. The ith entry \code{w[i]} denotes the weight used between the ith pair of centroids. The weights are in dictionary order.}

\item{Gamma1}{A regularization parameter controls cluster size .}

\item{Gamma2}{A regularization parameter controls the number of informative features .}

\item{Gamma2_weight}{The weight  to adaptively penalize the features.}

\item{nu}{A positive penalty parameter for quadratic deviation term.}

\item{tol_abs}{The convergence tolerance (absolute).}

\item{tol_rel}{The convergence tolerance (relative).}

\item{max_iter}{The maximum number of iterations.}

\item{type}{An integer indicating the norm used: 2 = 2-norm. (Only L2 norm are supported for now)}

\item{verbose}{report convergence information}

\item{method}{method to fit the sparse convex clustering ("ama" or "admm"). Default is ama}

\item{init}{initial vlaue of the method}
}
\value{
\code{U} A list of centroid matrices.

\code{V} A list of centroid difference matrices.

\code{Lambda} A list of Lagrange multiplier matrices.

\code{iters} number of iterations.

\code{eva}   the absolute difference of U between two most recent iteration.

\code{method} fitted method ("ama" or "admm")
}
\description{
The function estimates the sparse convex clustering path via AMA or ADMM.
Required inputs include a data matrix \code{X} (rows are samples; columns are features), a vector of weights
\code{w}, regularization parameters \code{Gamma1}, \code{Gamma2} and the adaptive weight \code{Gamma2_weight}.
}

