% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_add.R
\name{hier_add}
\alias{hier_add}
\title{Add nodes to an existing hierarchy}
\usage{
hier_add(tree, root, nodes)
}
\arguments{
\item{tree}{a (nested) hierarchy created using \code{\link{hier_create}}
or modified using \code{\link{hier_add}}, \code{\link{hier_delete}}
or \code{\link{hier_rename}}.}

\item{root}{(character) a name of an existing node in the hierarchy}

\item{nodes}{(character) names of new nodes that should be added below
\code{"root"}}
}
\description{
This function allows to add nodes (levels)
to an existing nested hierarchy.
}
\examples{
h <- hier_create(root = "Total",  nodes = LETTERS[1:3])
h <- hier_add(h, root = "A", nodes = c("a1", "a5"))
hier_display(h)
}
