% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_export.R
\name{hier_export}
\alias{hier_export}
\title{Export a hierarchy into a file}
\usage{
hier_export(tree, as = "df", path, verbose = FALSE)
}
\arguments{
\item{tree}{a (nested) hierarchy created using \code{\link[=hier_create]{hier_create()}}
or modified using \code{\link[=hier_add]{hier_add()}}, \code{\link[=hier_delete]{hier_delete()}} or \code{\link[=hier_rename]{hier_rename()}}.}

\item{as}{(character) specifying the export format. Possible choices are:
\itemize{
\item \code{"df"}: a \code{data.frame} with two columns. The first
columns contains a string containing as many \code{@} as the level of the
node in the string (e.g \code{@} corresponds to the overall
total while \code{@} would be all codes contributing to the total.
The second column contains the names of the levels.
\item \code{"dt"}: like the \code{df}-version but this result is
converted to a \code{data.table}
\item \code{"argus"}: used to create hrc-files suitable for tau-argus
\item \code{"json"}: json format suitable e.g. as input for
the shinyTree package.
\item \code{"code"}: code required to generate the hierarchy
\item \code{"sdc"}: a \code{list} which is a suitable input for \code{sdcTable}
}}

\item{path}{(character) relative or absolute path where results should
be written to}

\item{verbose}{(logical) additional results}
}
\description{
This function allows to write nested hierarchies into files
on your disk.
}
\examples{
h <- hier_create(root = "Total", nodes = LETTERS[1:2])
h <- hier_add(h, root = "A", nodes = c("a1", "a2"))
h <- hier_add(h, root = "B", nodes = c("b1", "b2"))
h <- hier_add(h, root = "b1", nodes = "b1a")
hier_display(h)

# export as input for tauArgus
hier_export(h, as = "argus", path = file.path(tempdir(), "h.hrc"))
}
