% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellInfo.R
\name{cellInfo}
\alias{cellInfo}
\title{query information for a specific cell in \code{\link{safeObj-class}} objects}
\usage{
cellInfo(object, characteristics, varNames, verbose = FALSE)
}
\arguments{
\item{object}{an object of class \code{\link{safeObj-class}}}

\item{characteristics}{a character vector specifying characteristics of the table cell that should be identified for each dimensional variable defining the table}

\item{varNames}{a character vector specifying variable names of dimensional variables defining the tables}

\item{verbose}{logical vector of length 1 defining verbosity, defaults to 'FALSE'}
}
\value{
a list containing the following calculated information
\itemize{
\item \code{cellID}: numeric vector of length 1 specifying the index of the cell within the final result dataset
\item \code{data}: a data.frame containing a single row with the index of the table cell of interest
\item \code{primSupp}: logical vector of length 1 that is 'TRUE' if the cell is a primary sensitive cell and 'FALSE' otherwise
\item \code{secondSupp}: logical vector of length 1 that is 'TRUE' if the cell is a secondary suppressed cell and 'FALSE' otherwise
}
}
\description{
Function \code{\link{cellInfo}} is used to query information for a single table cell
for objects of class \code{\link{safeObj-class}}.
}
\note{
Important: the \code{i}-th element of argument \code{characteristics} is uses as the desired characteristic for the dimensional variable specified at the \code{i}-th position of argument \code{varNames}!
}
\examples{
# load protected data (as created in the example
# of \code{\link{protectTable}})
sp <- searchpaths()
fn <- paste(sp[grep("sdcTable", sp)], "/data/protectedData.RData", sep="")
protectedData <- get(load(fn))
characteristics <- c('male', 'D')
varNames <- c('gender', 'region')
info <- cellInfo(protectedData, characteristics, varNames, verbose=FALSE)

# show the info about this cell
str(info)

}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
