#' Bayesian inference for error prediction .
#'
#' \code{bn_flag_inference} use the trained Bayesian Network model
#' to predict the errors that may happen in the dataset.
#'
#' @param dataset A data frame.
#' @param fit_model A bn fit model generated by \code{\link[bnlearn:bn.fit]{bn.fit}} or \code{\link{gen_bn_learn}} or \code{\link{gen_bn_elicit}}.
#' @return The output is a data frame inferred error flags.
#' @examples
#' adult_with_flag <- add_random_error(adult[1:100,], prob = c(0.97, 0.03), "age_missing")
#' adult_with_flag <- split_data(adult_with_flag, 70)
#' bn_learn <- gen_bn_learn(adult_with_flag$training_set, "hc")
#' syn_error_occurrence <- bn_flag_inference(bn_learn$gen_data, bn_learn$fit_model)
#' syn_error_occurrence
#'
#' @export
bn_flag_inference <- function(dataset, fit_model)
{
  node_names <- colnames(dataset[grepl("flag", colnames(dataset))])
  tmp <- dataset[grepl("flag", colnames(dataset))]

  for (i in 1:nrow(dataset))
  {
    tmp[i, ] <- bnlearn::cpdist(fit_model, nodes = node_names,
                                evidence = as.list(dataset[i,!grepl("flag", colnames(dataset))]),
                                n = 1,
                                method = "lw")
  }

  return(tmp)
}
