% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\encoding{UTF-8}
\name{correlation_groups}
\alias{correlation_groups}
\title{Groups layers based on the Pearson correlation}
\usage{
correlation_groups(layers_correlation, max_correlation=0.7)
}
\arguments{
\item{layers_correlation}{matrix or dataframe. A square matrix with the
layers correlations  you want to group.}

\item{max_correlation}{number. The maximum correlation 2 layers may have
before they are put in the same correlation group.}
}
\value{
A list of vectors with each vector containing the layer codes of one
  correlation group.
}
\description{
\code{correlation_groups} returns groups of layer codes such as each layer
from one group has an absolute Pearson product-moment correlation coefficient
(Pearson's r) that is smaller than the maximum_correlation (default 0.7) with
each variable in any other group. The correlation values of quadratic layers
are used for creating the groups but only non quadratic layer codes are 
returned.
}
\examples{

corr <- layers_correlation(c("BO_calcite", "BO_damin", "MS_bathy_5m"))
print(corr)
print(correlation_groups(corr, max_correlation=0.6))

}
\references{
Dormann, C. F., Elith, J., Bacher, S., Buchmann, C., Carl, G.,
  Carre, G., ... Lautenbach, S. (2013). Collinearity: a review of methods to
  deal with it and a simulation study evaluating their performance.
  Ecography, 36(1), 027-046. doi:10.1111/j.1600-0587.2012.07348.x 
  Barbet-Massin, M. & Jetz, W. (2014). A 40-year, continent-wide,
  multispecies assessment of relevant climate predictors for species
  distribution modelling. Diversity and Distributions, 20(11), 1285-1295.
  doi:10.1111/ddi.12229
}
\seealso{
\code{ \link{layers_correlation} \link{list_layers}
  \link{layer_stats}}
}

