% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doptimal.R
\name{doptimal}
\alias{doptimal}
\title{D-Optimal Experimental Design}
\usage{
doptimal(V)
}
\arguments{
\item{V}{a pxn matrix containing a set of n test vectors in dimension p (with p <= n)}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant C matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{doptimal} creates input for sqlp to solve the D-Optimal Experimental Design problem -
given an nxp matrix with p <= n, find the portion of points that maximizes det(A'A)
}
\details{
Solves the D-optimal experimental design problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(DoptDesign)

out <- doptimal(DoptDesign)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b
OPTIONS <- out$OPTIONS

}

