% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratification.R
\name{hclustgeo_disc}
\alias{hclustgeo_disc}
\title{hierarchical clustering with spatial soft constraints}
\usage{
hclustgeo_disc(
  data,
  n,
  alpha = 0.5,
  D1 = NULL,
  hclustm = "ward.D2",
  scale = TRUE,
  wt = NULL,
  ...
)
}
\arguments{
\item{data}{An \code{sf} object, \code{tibble}, \code{data.frame}, \code{matrix} or \code{vector} of observations data.}

\item{n}{The number of hierarchical clustering classes, which can be a numeric value or vector.}

\item{alpha}{(optional) A positive value between \code{0} and \code{1}. This mixing parameter gives the
relative importance of "feature" space and "constraint" space. Default is \code{0.5}.}

\item{D1}{(optional) A \code{matrix} with other dissimilarities between the same observations data. if \code{data}
is an \code{sf} object and alpha is not \code{0}, the \code{D1} will be generated by \code{sdsfun::sf_distance_matrix()},
others will use a \code{matrix} with all elements equal to \code{0}.}

\item{hclustm}{(optional) The agglomeration method to be used, default is \code{ward.D2}. For more details,
please see \code{stats::hclust()}.}

\item{scale}{(optional) Whether to scaled the dissimilarities matrix, default is \code{TRUE}.}

\item{wt}{(optional) Vector with the weights of the observations. By default, \code{wt} is \code{NULL}.}

\item{...}{(optional) Other arguments passed to \code{stats::dist()}.}
}
\value{
The grouped membership: a \code{vector} if \code{n} is a scalar, a \code{matrix} (columns correspond to elements
of \code{n}) if not.
}
\description{
hierarchical clustering with spatial soft constraints
}
\note{
This is a \verb{C++} enhanced implementation of the \code{hclustgeo} function in \code{ClustGeo} package.
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
gzma$group = hclustgeo_disc(gzma,5,alpha = 0.75)
plot(gzma["group"])

}
