% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\title{Interactively Inspect a Seasonal Adjustment Model}
\usage{
inspect(x, fun = NULL, check.version = TRUE, quiet = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{"seas"}.}

\item{fun}{a function or a list of functions (see details)}

\item{check.version}{logical, should the version of shiny be checked}

\item{quiet}{logical, if \code{TRUE} (default), error messages from calls in 
inspect are not shown in the console}

\item{...}{further arguments, passed on to 
\code{\link[shiny]{runApp}}. (The \code{launch.browser} argument of 
version 0.8 can be still used that way)}
}
\value{
an object of class \code{"seas"}, the modified model.
}
\description{
Interactively inspect a \code{"seas"} object. The goal of \code{inspect} is 
to summarize all relevant options, plots and statistics that should be 
usually considered.
}
\details{
Frequently used options can be modified using the drop down selectors in the
upper left window. Each change will result in a re-estimation of the seasonal
adjustment model. The R-call, the output and the summary are updated
accordingly.

Alternatively, the R-Call can be modified manually in the lower left window.
Press 'Run Call' to re-estimate the model and to adjust the option selectors,
the output, and the summary. With the 'Close and Import' button, inspect is 
closed and the call is imported to R. The 'static' button substitutes 
automatic procedures by the automatically chosen 
spec-argument options, in the same way as \code{\link{static}}.

The views in the upper right window can be selected from the drop down menu.

The lower right panel shows the summary, as descibed in the help page of
\code{\link{summary.seas}}. The 'Full X-13 output' button opens the complete 
output of X-13 in a separate tab or window.

The views in \code{inspect} can be customized via the \code{fun} argument.
One or several plot functions may be supplied. The plot functions should have
a \code{"seas"} object as their only argument. Several functions must be 
wrapped in a list (see examples).
}
\examples{
\dontrun{

m <- seas(AirPassengers)

inspect(m)

m2 <- inspect(m)  # save the model after closing the GUI

### customizing inspect

# a single function
# a new item 'User Plot' can be chosen in the 'View' menu
inspect(m, fun = function(x) hist(resid(x)))  

# more than one function collected in a list
myfun <- list()
myfun[['Spectum X-13']] <- function(m){
  plot(series(m, "spectrum.specorig", verbose = FALSE)[,-1], t = "l")
}
myfun[['Spectum R']] <- function(m){
  spectrum(diff(log(AirPassengers)), method = "ar", main = "")
}
inspect(m, myfun)

# and a bonus example
spaghetti <- function(m, back = 10){
ser <- original(m)
tx <- time(ser)[(length(ser) - back):length(ser)]
z <- NULL
for (txi in tx){
  assign(as.character(m$call$x), window(ser, end = txi))
  z <- cbind(z, final(eval(m$call)))
}
ts.plot(window(z, start = time(ser)[(length(ser) - back- 15)]), 
        col = rainbow(back + 1))
}
inspect(m, spaghetti)

}
}
\seealso{
\code{\link{seas}} for the main function of seasonal.
}

