% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{final}
\alias{final}
\alias{original}
\alias{trend}
\alias{irregular}
\alias{residuals.seas}
\title{Time Series of a Seasonal Adjustment Model}
\usage{
final(object)

original(object)

trend(object)

irregular(object)

\method{residuals}{seas}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"seas"}.}

\item{...}{not used. For compatibility with the generic.}
}
\value{
returns a \code{"ts"} object, depending on the function.
}
\description{
Functions to extract the main time series from a \code{"seas"} object. For
universal import of X-13ARIMA-SEATS tables, use the \code{\link[=series]{series()}}
function.
}
\details{
These functions support R default NA handling. If \code{na.action = na.exclude} is specified in the call to \code{seas}, the time series will
also contain NAs.
}
\examples{
\donttest{

m <- seas(AirPassengers)

final(m)
original(m)
irregular(m)
trend(m)

# NA handling
AirPassengersNA <- window(AirPassengers, end = 1962, extend = TRUE)
final(seas(AirPassengersNA, na.action = na.omit))    # no NA in final series
final(seas(AirPassengersNA, na.action = na.exclude)) # NA in final series
final(seas(AirPassengersNA, na.action = na.x13))     # NA filled by x13
# final(seas(AirPassengersNA, na.action = na.fail))    # fails
}
}
\references{
Vignette with a more detailed description:
\url{http://www.seasonal.website/seasonal.html}

Comprehensive list of R examples from the X-13ARIMA-SEATS manual:
\url{http://www.seasonal.website/examples.html}

Official X-13ARIMA-SEATS manual:
\url{https://www.census.gov/ts/x13as/docX13ASHTML.pdf}
}
\seealso{
\code{\link[=seas]{seas()}} for the main function of seasonal.

\code{\link[=series]{series()}}, for universal X-13 output extraction.
}
