% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{spc}
\alias{spc}
\title{\code{.spc} File Content}
\usage{
spc(x)
}
\arguments{
\item{x}{object of class \code{"seas"}}
}
\value{
returns an object of class \code{"spclist"}, essentially a list that
contains the information that is sent to X-13ARIMA-SEATS. The corresponding
\code{print} method displays the content of the list as written to the
\code{.spc} file.
}
\description{
Access the content of the \code{.spc} file that governs the behavior of
X-13ARIMA-SEATS.
}
\examples{
\donttest{

m <- seas(AirPassengers)
spc(m)
}
}
\references{
Vignette with a more detailed description:
\url{http://www.seasonal.website/seasonal.html}

Comprehensive list of R examples from the X-13ARIMA-SEATS manual:
\url{http://www.seasonal.website/examples.html}

Official X-13ARIMA-SEATS manual:
\url{https://www.census.gov/ts/x13as/docX13ASHTML.pdf}
}
\seealso{
\code{\link[=seas]{seas()}} for the main function.

\code{\link[=series]{series()}}, for universal X-13 output extraction.

\code{\link[=plot.seas]{plot.seas()}}, for diagnostical plots.

\code{\link[=out]{out()}}, for accessing the full output of X-13ARIMA-SEATS.
}
