% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welch.R
\name{welch}
\alias{welch}
\title{Welch seasonality test}
\usage{
welch(x, freq = NA, diff = T, residuals = F, autoarima = T, rank = F)
}
\arguments{
\item{x}{time series}

\item{freq}{Frequency of the time series}

\item{diff}{Shall the differenced series be tested?}

\item{residuals}{Shall the residuals of an ARIMA model be tested?}

\item{autoarima}{Use automatic instead of a (0,1,1) ARIMA model?}

\item{rank}{Use rank of series instead of actual values?}
}
\description{
Test for seasonality in a time series using Welch's ANOVA test.
}
\details{
If residuals=FALSE the autoarima parameter is ignored.

If rank=TRUE, the test becomes basically a combination of the Kruskall-Wallis and the Welch test.

If residuals=TRUE, a non-seasonal ARIMA model is estimated for the time series. And the residuals of the fitted model are used as input to the test statistic. If an automatic order selection is used, the Hyndman-Khandakar algorithm is employed with max(p)=max(q) <= 3.
}
\examples{
welch(ts(rnorm(120, 10,10), frequency=12))
welch(ts(rnorm(1200, 10,10), frequency=7))
}
\references{
Kruskal, W. H. and W. A.Wallis (1952). Use of Ranks in One-Criterion Variance Analysis. Journal of the American Statistical Association 47 (260), 583-621.

Welch, B. L. (1951). On the Comparison of Several Mean Values: An Alternative Approach. Biometrika 38 (3/4), 330-336.
}
\author{
Daniel Ollech
}
