% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSNPs_utility.R
\docType{methods}
\name{scoreLocal}
\alias{scoreLocal}
\alias{scoreLocal,Chrom-method}
\alias{scoreLocal,Map-method}
\title{Compute the weighted local score}
\usage{
scoreLocal(object, ...)

\S4method{scoreLocal}{Chrom}(object, t1 = 1, t2 = 1, w1 = 0.5, w2 = 0.5)

\S4method{scoreLocal}{Map}(object, chrom, t1 = 1, t2 = 1, w1 = 0.5, w2 = 0.5)
}
\arguments{
\item{object}{A vector of minor allele frequency values.}

\item{...}{Extra input parameters, as needed.}

\item{t1}{A shrinkage parameter on the E score, which by default is 1.}

\item{t2}{A shrinkage parameter on the U score, which by defaukt us 1.}

\item{w1}{A weight for MAF, wchich by default is 0.5.}

\item{w2}{A weight for map position, which by default is 0.5.}

\item{chrom}{Names of chromosomes, for which local scores are to be computed; optioonal.}
}
\value{
The computed local score of the input object.
}
\description{
This function computes the weighted Local score, which is the weighted average between
the U score and the E socre, with the weights given from the inputs.
}
\examples{
data("bov80K")
scoreLocal(bov80K)

}
\references{
Wu XL, Li H, Ferretti R, Simpson B, Walker J, Parham J, Mastro L, Qiu J, Schultz T, 
Tait RG Jr, Bauck S, (2010). A unified local objective function for optimally selecting SNPs on 
arrays for agricultural genomics applications. Anim Genet. 2020 Jan 31. doi: 10.1111/age.12916.
}
\author{
Nick X-L Wu
}
